%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% post processor - arrange FEM-2D in matrices
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
clear all 
close all;	% close all the open figure windows

%%%%%%%%%%% read meshinp.txt %%%%%%%%%%%%
fid = fopen('meshinp.txt','r');
line = fgets(fid);	% read line (Darcy)
line = fgets(fid);	% read line (Xmin, Xmax, Ymin, Ymax)
line = fgets(fid);	% read line (Nx, Ny, Ns)
v = sscanf(line, '%i');
Nx = v(1);
Ny = v(2);

%%%%%%%%%%% read finp.txt %%%%%%%%%%%%
fid = fopen('finp.txt','r');

line = fgets(fid);	% read line (Ne, Nn, Nb, Nm, Np)
line = fgets(fid);	% read line (Nd, Ng, Ns)
v = sscanf(line, '%i');
Ns = v(3);
line = fgets(fid);	% read line (Sx, Kappa, tc, por)
line = fgets(fid);	% read line (tmax, dt, dto)
v = sscanf(line, '%e');
tmax = v(1);
dto = v(3);
Nto = (tmax + 1e-6) / dto;

%%%%%%%%%% read post.msh %%%%%%%%%%%
fid = fopen('post.msh','r');
for m =1:6
  line = fgets(fid);	% read 6 lines
end	% m

% read nodal coordinates
for j = 1:Ny+1
  for i = 1:Nx+1
    line = fgets(fid);	% read line (n, x, y, z)
%    v = sscanf(line, '%i %e %e %e');
  end	% i
end	% j

for m =1:5
  line = fgets(fid);	% read 5 lines
end	% m

% read elements
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number elm-type number-of-tags < tag > ... node-number-list)
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m

% read elements data (V)
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number number-of-nodes-per-element value ... Dxx, Dxy,.. Dzz)
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m

% read elements data (D)
for j = 1:Ny
  for i = 1:Nx
    line = fgets(fid);	% read line (elm-number number-of-nodes-per-element value ... Dxx, Dxy,.. Dzz)
  end	% i
end	% j

for m =1:12
  line = fgets(fid);	% read 12 lines
end	% m

% time loop
for t=0:Nto

% read nodal data (Cs)
  for s = 1:Ns
    for j = 1:Ny+1
      for i = 1:Nx+1
        line = fgets(fid);	% read line (node-number value ...)
        v = sscanf(line, '%i %e');
        C(t+1,s,j,i) = v(2);
      end	% i
    end		% j

    for m =1:12
      line = fgets(fid);	% read 12 lines
    end		% m
  end		% s

% read nodal data (Ts)
  for s = 1:Ns
    for j = 1:Ny+1
      for i = 1:Nx+1
        line = fgets(fid);	% read line (node-number value ...)
        v = sscanf(line, '%i %e');
        T(t+1,s,j,i) = v(2);
      end	% i
    end		% j

    for m =1:12
      line = fgets(fid);	% read 12 lines
    end		% m
  end		% s
end		% t

% % read nodal data (q_i)
% for j = 1:Ny+1
%   for i = 1:Nx+1
%     line = fgets(fid);	% read line (node-number value ...)
%     v = sscanf(line, '%i %e %e %e');
%     qx(j,i)= v(2);
%     qy(j,i)= v(3);
%   end	% i
% end	% j

% C1 = reshape(C(:,1,:,:),[(Ny+1)*(Nx+1),t+1,]);
% C2 = reshape(C(:,2,:,:),[(Ny+1)*(Nx+1),t+1,]);
% C3 = reshape(C(:,3,:,:),[(Ny+1)*(Nx+1),t+1,]);

fclose('all');  % close all files
